import sys, pygame, math, numpy, random, time, copy
from pygame.locals import * 

from constants import *
from utils import *
from core import *

### Returns true if the agent can get from p1 to p2 directly without running into an obstacle.
### p1: the current location of the agent
### p2: the destination of the agent
### worldLines: all the lines in the world
### agent: the Agent object
def clearShot(p1, p2, worldLines, worldPoints, agent):
	### YOUR CODE GOES BELOW HERE ###
        retValue = True
        agentSize = 2*agent.getRadius()

        if retValue == True and rayTraceWorld(p1,p2,worldLines) is not None:
                retValue = False
        
        for point in worldPoints:
                if retValue == True and minimumDistance((p1,p2),point)< agentSize:
                        retValue = False
                else :
                        if retValue == False:
                                break

        return retValue
	### YOUR CODE GOES ABOVE HERE ###
	return False

### This function optimizes the given path and returns a new path
### source: the current position of the agent
### dest: the desired destination of the agent
### path: the path previously computed by the Floyd-Warshall algorithm
### world: pointer to the world
def shortcutPath(source, dest, path, world, agent):
	### YOUR CODE GOES BELOW HERE ###
        # if current position has a clear shot to a later node, skip it
        myPos = source
        i = -1
        j = len(path)
        k = len(path)

        while i< j:
                previousNodes = []
                nodesToRemove = []
                if i == -1 :
                        myPos = source
                else :
                        myPos = path[i]
                for node in path:
                        if path.index(node)>i:
                                if node != path[i+1] and clearShot(myPos,node,world.getLines(),world.getPoints(),agent):
                                        for collectedNode in previousNodes:
                                                if collectedNode not in nodesToRemove:
                                                        nodesToRemove.append(collectedNode)
                                                        myPos = node
                                else:
                                        previousNodes.append(node)
                for deletedNode in nodesToRemove:
                        if deletedNode in path:
                                path.remove(deletedNode)
                                
                j = len(path)
                if j<k :
                        k = j
                        i = 0
                else:
                        i+=1
                
	### YOUR CODE GOES BELOW HERE ###
	return path


### This function changes the move target of the agent if there is an opportunity to walk a shorter path.
### This function should call nav.agent.moveToTarget() if an opportunity exists and may also need to modify nav.path.
### nav: the navigator object
### This function returns True if the moveTarget and/or path is modified and False otherwise
def mySmooth(nav):
	### YOUR CODE GOES BELOW HERE ###
        plannedPath = nav.path                          #path that the agent is following currently

        if plannedPath :
                if clearShot(nav.agent.getLocation(),plannedPath[0],nav.agent.world.getLines(),nav.agent.world.getPoints(), nav.agent):
                        if nav.agent.moveTarget != plannedPath[0]:
                                nav.agent.moveToTarget(plannedPath[0])
                                plannedPath.remove(plannedPath[0])
                        return True
        else :
                if nav.destination:
                        if clearShot(nav.agent.getLocation(),nav.destination,nav.agent.world.getLines(),nav.agent.world.getPoints(), nav.agent):
                                nav.agent.moveToTarget(nav.destination)
                        
	### YOUR CODE GOES ABOVE HERE ###
	return False


